// 05_SDF_designs     designs of SDFs
// ....................................................
const SDF_designs = [];

SDF_designs[ 0 ] = `   // don't change this line 
    float t = mod(time * 0.1, 1.0);
    float vStep = 1.0 / 4.0;
    
    vec3 dataPosition = texture(splineData, vec2(t, vStep * 0.5)).rgb;
    vec3 dataTangent  = texture(splineData, vec2(t, vStep * 1.5)).rgb;
    vec3 dataNormal   = texture(splineData, vec2(t, vStep * 2.5)).rgb;
    vec3 dataBinormal = texture(splineData, vec2(t, vStep * 3.5)).rgb;
    
    float axesLength = 0.6;
    
    //... SDF ...  
    distCol dcCapsuleTangent;
    dcCapsuleTangent.d = sdCapsule(p, dataPosition, dataPosition + dataTangent * axesLength, 0.05);
    dcCapsuleTangent.c =  vec4(1.0, 1.0, 0.2, 1.0);
    distCol dcCapsuleNormal;
    dcCapsuleNormal.d = sdCapsule(p, dataPosition, dataPosition + dataNormal * axesLength, 0.05);
    dcCapsuleNormal.c =  vec4(0.2, 1.0, 0.2, 1.0);
    distCol dcCapsuleBinormal;
    dcCapsuleBinormal.d = sdCapsule(p, dataPosition, dataPosition + dataBinormal * axesLength, 0.05);    
    dcCapsuleBinormal.c =  vec4(0.2, 0.8, 1.0, 1.0);

    dc = dcCapsuleTangent;
    dc = opUnion(dc, dcCapsuleNormal);
    dc = opUnion(dc, dcCapsuleBinormal);

 `;  // don't change this line
 
 
 
///................................................................. 
 
export { SDF_designs } // don't change this line
